/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWActionType;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWExpr;
import java.io.Serializable;
import java.util.Vector;

public final class VWRollbackInstruction
extends VWInstructionDefinition
implements Serializable {
    private static final long serialVersionUID = 7447L;
    private String[] params = null;
    private String compCallIS = null;
    private String reDoExpr = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-19 01:22:05 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/6 $";
    }

    protected VWRollbackInstruction() throws VWException {
    }

    protected VWRollbackInstruction(VWCompoundStepDefinition aStep, int theInstructionId, String[] theParameters, String theCompCallIS, String theReDo) throws VWException {
        super(aStep, theInstructionId, 29);
        this.setParams(theParameters);
        this.setCompCall(theCompCallIS);
        this.setReDo(theReDo);
    }

    public String[] getParams() {
        return this.params;
    }

    public void setParams(String[] theParams) throws VWException {
        this.params = theParams;
    }

    public String getCompCall() {
        return this.compCallIS;
    }

    public void setCompCall(String theCompCallIS) throws VWException {
        this.compCallIS = theCompCallIS;
    }

    public String getReDo() {
        return this.reDoExpr;
    }

    public void setReDo(String theReDoExpr) throws VWException {
        this.reDoExpr = theReDoExpr;
    }

    public void validate(VWSession theSession, Vector EDefVector, VWCompoundStepDefinition myStep) throws VWException {
        VWValidationContext validationContext = new VWValidationContext(theSession, EDefVector);
        this.validate(validationContext, myStep);
    }

    protected void validate(VWValidationContext validationContext, VWCompoundStepDefinition myStep) throws VWException {
        block14: {
            VWWorkflowSignature myWflSignature = this.getStep().getMap().getWorkflow().getWorkflowSignature(validationContext);
            VWWorkflowSignature myBaseWflSignature = this.getStep().getMap().getWorkflow().getBaseWorkflowSignature(validationContext);
            if (this.reDoExpr != null && this.reDoExpr.length() == 0) {
                VWString theMessage = new VWString("vw.api.VWRollbackInstructionEmptyReDoExpr", "Re-do expression must be either null or a valid boolean expression.");
                VWValidationError theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError);
            } else if (this.reDoExpr != null) {
                VWCompiledExpr compRes = new VWCompiledExpr();
                String[] theErrorStrings = VWExpr.compileVWExpr(this.reDoExpr, myWflSignature, myBaseWflSignature, null, null, true, compRes);
                if (theErrorStrings != null) {
                    int errorCount = theErrorStrings.length;
                    for (int i = 0; i < errorCount; ++i) {
                        VWString theMessage = new VWString("vw.api.VWRollbackInstructionSyntaxErrorInReDoExpr", "Syntax error in re-do expression of rollback checkpoint instruction (expected boolean expression) : {0}", theErrorStrings[i]);
                        VWValidationError theError = new VWValidationError(7, 1, myStep.getName(), this.reDoExpr, theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError);
                    }
                } else if (compRes.getResultIsArray() || compRes.getResultType() != 4) {
                    VWString theMessage = new VWString("vw.api.VWRollbackInstructionReDoNotBoolean", "Re-do expression parameter must be a boolean expression, found a {0}.", VWFieldType.typeToString(compRes.getResultType()) + (compRes.getResultIsArray() ? "[ ]" : ""));
                    VWValidationError theError = new VWValidationError(7, 1, myStep.getName(), this.reDoExpr, theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                }
            }
            if (this.compCallIS != null && VWMapDefinition.mapNameToId(this.compCallIS) == 0) {
                try {
                    myStep.getMap().getWorkflow().getMap(this.compCallIS);
                }
                catch (Exception e) {
                    if (myBaseWflSignature != null && myBaseWflSignature.isInstructionSheetName(this.compCallIS)) break block14;
                    VWString theMessage = new VWString("vw.api.VWRollbackInstructionMapNotFound", "The compensation call map, {0}, was not found in this workflow definition.", this.compCallIS);
                    VWValidationError theError = new VWValidationError(7, 1, myStep.getName(), this.compCallIS, theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.getInstructionId());
                    validationContext.addValidationError(theError);
                }
            }
        }
        if (this.params != null) {
            VWWorkflowSignature baseWCSig = myStep.getMap().getWorkflow().getBaseWorkflowSignature(validationContext);
            for (int i = 0; i < this.params.length; ++i) {
                if (this.params[i] != null) {
                    if (myStep.getMap().getWorkflow().isExistingFieldName(this.params[i])) continue;
                    boolean found = false;
                    if (baseWCSig != null && baseWCSig.findField(this.params[i]) != null) {
                        found = true;
                    }
                    if (found) continue;
                    VWString theMessage = new VWString("vw.api.VWRollbackInstructionFieldNotFound", "The field name, {0}, listed as one of the non-rollback fields, was not found in this workflow definition.", this.params[i]);
                    VWValidationError theError = new VWValidationError(7, 2, myStep.getName(), this.compCallIS, theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.getInstructionId());
                    validationContext.addValidationError(theError);
                    continue;
                }
                VWString theMessage = new VWString("vw.api.VWRollbackInstructionNullParameter", "Non-rollbackfield list contains a null field name at offset {0}.", String.valueOf(i));
                VWValidationError theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError);
            }
        }
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWRollbackInstructionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t\t\t<RBInstruction\n");
        theBuffer.append(ATTRIB_INDENT + "Id=\"" + Integer.toString(this.getInstructionId()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "Action=\"" + VWActionType.typeToString(this.getAction()) + "\"\n");
        if (this.reDoExpr != null) {
            theBuffer.append(ATTRIB_INDENT + "ReDo=\"" + VWXMLHandler.toXMLString(this.reDoExpr) + "\"\n");
        }
        if (this.compCallIS != null) {
            theBuffer.append(ATTRIB_INDENT + "CompCall=\"" + VWXMLHandler.toXMLString(this.compCallIS) + "\"");
        }
        theBuffer.append(">\n");
        if (this.params != null) {
            for (int i = 0; i < this.params.length; ++i) {
                if (this.params[i] == null) continue;
                theBuffer.append(ATTRIB_INDENT + "<Expression Val=\"" + VWXMLHandler.toXMLString(this.params[i]) + "\" />\n");
            }
        }
        theBuffer.append("\t\t\t</RBInstruction>\n");
    }

    public String toString() {
        String retVal = "";
        try {
            retVal = VWActionType.typeToString(this.action) + "(" + (this.compCallIS == null ? "" : this.compCallIS + ", ");
            for (int i = 0; i < this.params.length; ++i) {
                retVal = " <" + this.params[i] + "> ";
            }
            retVal = retVal + ")";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }
}

